package com.ht.dao;

import rx.functions.Action1;
import rx.functions.Func1;

import com.couchbase.client.java.AsyncBucket;
import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.CouchbaseCluster;
import com.couchbase.client.java.document.JsonDocument;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.env.DefaultCouchbaseEnvironment;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.ht.util.ConnectionUtil;
import com.ht.vo.Customer;

public class LearningCouchbaseDAO {

	final  Bucket theBucket;
	
	
	public LearningCouchbaseDAO(String cbHost,String bucketName, String password) throws Exception {
		super();
		theBucket = ConnectionUtil.getTheBucket(cbHost, bucketName, password);
	}


	public long createCustomerDocument(String docID,Customer cust){
		
		Gson gson = new GsonBuilder().create();
		JsonObject content = JsonObject.fromJson(gson.toJson(cust));
		JsonDocument doc = JsonDocument.create(docID,content  );
		JsonDocument insertDoc = theBucket.insert(doc);
		return insertDoc.cas();
		
	}
	
  public Customer updateCustomerDocument(String docID,Customer cust){
		
		Gson gson = new GsonBuilder().create();
		JsonObject content = JsonObject.fromJson(gson.toJson(cust));
		JsonDocument doc = JsonDocument.create(docID,content  );
		JsonDocument updateDoc = theBucket.replace(doc);
		return gson.fromJson(updateDoc.content().toString(), Customer.class);
		
	}
	public Customer findCustomerDocument(String docID){
		
		Gson gson = new GsonBuilder().create();
		JsonDocument fDoc = theBucket.get(docID);
		Customer cust = gson.fromJson(fDoc.content().toString(), Customer.class);
		return cust;
		
	}
	
	public boolean deleteCustomerDocument(String docID){
		
		theBucket.remove(docID);
		return true;
		
	}
	
	public Customer getCustomerDocumentWithLock(String docID){
		 AsyncBucket aBucket = theBucket.async();
		aBucket.get("2007").map(new Func1<JsonDocument, String>() {
						        public String call(JsonDocument jsonDocument) {
						           jsonDocument.content().put("name"," Mr " + jsonDocument.content().getString("name")); 
						            return jsonDocument.content().getString("name");
						        }
						    }).subscribe(new Action1<String>() {
					      
					        public void call(String name) {
					            System.out.println(" Async Call : " + name);
					        }
					    });
		
		System.out.println(" Simple Get :" + theBucket.get("2007").content().get("name"));
		
		// Creation of cluster environment
		
		CouchbaseEnvironment clusterEnv = DefaultCouchbaseEnvironment
			    .builder()
			    .computationPoolSize(5)
			    .build();

		Cluster cluster = CouchbaseCluster.create(clusterEnv, "localhost");
		
		
		return null;
		
	}
	
	
	
}
